package products;

import structure.device.Light;
import structure.device.Shutter;
import structure.location.Floor;
import structure.location.House;
import structure.location.Room;

public class NantesHouse extends House {
	protected Floor firstFloor;

	public NantesHouse() {
		layout();
	}

	protected void layout() {
		firstFloor = new Floor();
		Room living = new Room();
		living.addShutter(new Shutter("[ParisHouse]firstFloor.shutter"));
		living.addLight(new Light("[ParisHouse]firstFloor.light1"));
		living.addLight(new Light("[ParisHouse]firstFloor.light2"));
		firstFloor.addRoom(living);
		addFloor(firstFloor);

		Floor secondFloor = new Floor();
		Room dorm = new Room();
		dorm.addShutter(new Shutter("[ParisHouse]secondFloor.shutter"));
		dorm.addLight(new Light("[ParisHouse]secondFloor.light"));
		secondFloor.addRoom(dorm);
		addFloor(secondFloor);
	}
}
